/*Tables*/
CREATE TABLE Emp
(ID INT PRIMARY KEY IDENTITY(1,1),
Name NVARCHAR(50),
DepartmentId INT CONSTRAINT FK_Emp_HPDepartment FOREIGN KEY REFERENCES 
	HumanResources.Department(DepartmentId),
ManagerId INT CONSTRAINT FK_Emp_ManagerId FOREIGN KEY REFERENCES Emp(ID))
GO
IF EXISTS (SELECT * FROM sys.objects WHERE name = 'FK_Emp_HPDepartment')
	ALTER TABLE Emp
		DROP CONSTRAINT FK_Emp_HPDepartment
GO
IF EXISTS (SELECT * FROM sys.objects WHERE name = 'FK_Emp_ManagerId')
	ALTER TABLE Emp
		DROP CONSTRAINT FK_Emp_ManagerId
GO
IF EXISTS (SELECT * FROM sys.tables WHERE name = 'Emp')
	DROP TABLE Emp
GO
/*Views*/
CREATE VIEW EmpDepts
AS
SELECT c.EmailAddress, 
	c.FirstName, 
	c.LastName,
	c.Phone,
	e.EmployeeID,
	e.BirthDate,
	e.Title,
	d.Name,
	d.GroupName,
	edh.ModifiedDate,
	d.DepartmentID 
FROM HumanResources.Employee e
JOIN HumanResources.EmployeeDepartmentHistory edh ON e.EmployeeID = edh.EmployeeID 
	AND edh.EndDate IS NULL
JOIN HumanResources.Department d ON edh.DepartmentID = d.DepartmentID 
JOIN Person.Contact c ON e.ContactID = c.ContactID 
GO
IF EXISTS (SELECT * FROM sys.views WHERE name = 'EmpDepts')
	DROP VIEW EmpDepts
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE name = 'EmpDepts')
	exec ('CREATE VIEW EmpDepts AS SELECT 1 as [t]')
GO
ALTER VIEW EmpDepts
AS
SELECT c.EmailAddress, 
	c.FirstName, 
	c.LastName,
	c.Phone,
	e.EmployeeID,
	e.BirthDate,
	e.Title,
	d.Name,
	d.GroupName,
	edh.ModifiedDate,
	d.DepartmentID 
FROM HumanResources.Employee e
JOIN HumanResources.EmployeeDepartmentHistory edh ON e.EmployeeID = edh.EmployeeID 
	AND edh.EndDate IS NULL
JOIN HumanResources.Department d ON edh.DepartmentID = d.DepartmentID 
JOIN Person.Contact c ON e.ContactID = c.ContactID 
GO

/*Procedures*/
ALTER PROCEDURE usp_EmpDepts
	@EmployeeId INT
AS
SELECT *
FROM EmpDepts
WHERE EmployeeID = @EmployeeId
GO
exec usp_EmpDepts 1
GO
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'usp_EmpDepts')
	DROP PROCEDURE usp_EmpDepts
GO
IF NOT EXISTS (SELECT * FROM sys.procedures WHERE name = 'usp_EmpDepts')
	exec ('CREATE PROCEDURE usp_EmpDepts AS SELECT 1')
GO
ALTER PROCEDURE usp_EmpDepts
	@EmployeeId INT
AS
SELECT *
FROM EmpDepts
WHERE EmployeeID = @EmployeeId
GO

/*Functions*/
CREATE FUNCTION GetEmployeeDepartment (@EmployeeId INT)
RETURNS INT
AS
BEGIN
	DECLARE @DepartmentId INT
	SELECT @DepartmentId = DepartmentID
	FROM EmpDepts
	WHERE EmployeeID = @EmployeeId	

	RETURN @DepartmentId
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE name = 'GetEmployeeDepartment')
	DROP FUNCTION GetEmployeeDepartment
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE name = 'GetEmployeeDepartment')
	exec ('CREATE FUNCTION GetEmployeeDepartment (@a INT) RETURNS INT AS BEGIN RETURN 0 END')
GO
ALTER FUNCTION GetEmployeeDepartment (@EmployeeId INT)
RETURNS INT
AS
BEGIN
	DECLARE @DepartmentId INT
	SELECT @DepartmentId = DepartmentID
	FROM EmpDepts
	WHERE EmployeeID = @EmployeeId	

	RETURN @DepartmentId
END
GO
SELECT dbo.GetEmployeeDepartment(2)
GO

/*Table Function*/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE name = 'GetEmployeesByDepartment')
	exec ('CREATE FUNCTION GetEmployeesByDepartment (@a INT) RETURNS @e TABLE (a INT) AS BEGIN RETURN END')
GO
ALTER FUNCTION GetEmployeesByDepartment (@DepartmentId INT)
RETURNS @Emp TABLE 
(
	EmployeeId INT
)
AS
BEGIN
	INSERT INTO @Emp
	SELECT EmployeeID
	FROM EmpDepts
	WHERE DepartmentID = @DepartmentId

	RETURN
END
GO
SELECT *
FROM dbo.GetEmployeesByDepartment(2)
GO
SELECT *
FROM EmpDepts
JOIN dbo.GetEmployeesByDepartment(2) a ON EmpDepts.EmployeeID = a.EmployeeId
GO
IF EXISTS (SELECT * FROM sys.objects WHERE name = 'GetEmployeesByDepartment')
	DROP FUNCTION GetEmployeesByDepartment
GO